# Headless Miner ARM64 - Installation Instructions

First go to https://webapp.sallar.app/linux and get your access token.

## Quick Installation

1. **Extract the archive:**

   ```bash
   tar -xzf sallar-miner-linux-aarch64.tar.gz
   cd sallar-miner-linux-aarch64/
   ```

2. **Run installation:**

   Make sure you have snap chromium installed before running the installation script (instructions below) then run:

   ```bash
   chmod +x install.sh
   ./install.sh
   ```

3. **Configure:**

   ```bash
   hm config
   # Set ACCESS_TOKEN in the editor
   ```

4. **Start:**
   ```bash
   hm start
   hm status
   ```

## Chrome/Chromium Installation

### Install via Snap (Recommended)

```bash
# Install Chromium via snap
sudo snap install chromium

# Connect snap to home directory (REQUIRED)
sudo snap connect chromium:home

# Verify connection
snap connections chromium | grep home
```

## Troubleshooting Snap Chromium

### Problem: Chromium can't access files

```bash
# Check snap connections
snap connections chromium

# If home is not connected, run:
sudo snap connect chromium:home

# Restart headless_miner after connecting
hm restart
```

### Problem: Permission denied errors

```bash
# Make sure snap has necessary permissions
sudo snap connect chromium:home
sudo snap connect chromium:network
sudo snap connect chromium:network-bind

# Check if user data directory is accessible
ls -la ~/sallar/
```

## Available Commands

- `hm start` - Start headless_miner
- `hm stop` - Stop headless_miner
- `hm restart` - Restart headless_miner
- `hm status` - Check service status
- `hm logs` - View logs in real-time
- `hm config` - Edit configuration (URL, token, etc.)
- `hm test` - Test connection to server
- `hm uninstall` - Remove headless_miner

## Uninstallation

Two options:

```bash
# Via manager
hm uninstall

# Or via script
./uninstall.sh
```

## Requirements

- ARM64 Linux (Ubuntu, Debian, CentOS, etc.)
- Chrome/Chromium browser (including snap chromium)
- Internet access
- Snap access to home directory (if using snap chromium)
