#!/bin/bash

# Quick Setup Script for headless_miner
# Quick configuration after first installation

set -e

echo "🚀 Quick headless_miner setup"
echo "=============================="

# Copy manager to ~/.local/bin
if [[ -f "headless-miner-manager.sh" ]]; then
    mkdir -p ~/.local/bin
    cp headless-miner-manager.sh ~/.local/bin/hm
    chmod +x ~/.local/bin/hm
    echo "✅ Copied manager as 'hm' to ~/.local/bin/"
else
    echo "❌ headless-miner-manager.sh not found"
    exit 1
fi

# Check PATH
if ! echo "$PATH" | grep -q "$HOME/.local/bin"; then
    echo 'export PATH="$HOME/.local/bin:$PATH"' >> ~/.bashrc
    echo "✅ Added ~/.local/bin to PATH"
    echo "⚠️  Run: source ~/.bashrc or open a new terminal"
fi

echo
echo "📋 Available commands:"
echo "  hm start          - Start headless_miner"
echo "  hm stop           - Stop headless_miner"
echo "  hm restart        - Restart headless_miner"
echo "  hm status         - Service status"
echo "  hm config         - Edit configuration (URL, token, etc.)"
echo "  hm test           - Test connection"
echo "  hm logs           - View logs"
echo "  hm uninstall      - Remove headless_miner"
echo

echo "🔧 Next steps:"
echo "1. Edit configuration: hm config"
echo "   (set MINER_URL and ACCESS_TOKEN)"
echo "2. Start service:      hm start"
echo "3. Check status:       hm status"

echo
echo "✅ Setup completed!" 